/*
 * Decompiled with CFR 0.152.
 */
package net.dries007.tfc.objects.blocks;

import com.google.common.collect.ImmutableList;
import net.dries007.tfc.ConfigTFC;
import net.dries007.tfc.TerraFirmaCraft;
import net.dries007.tfc.api.registries.TFCRegistries;
import net.dries007.tfc.api.types.Metal;
import net.dries007.tfc.api.types.Ore;
import net.dries007.tfc.api.types.Plant;
import net.dries007.tfc.api.types.Rock;
import net.dries007.tfc.api.types.Tree;
import net.dries007.tfc.api.util.FallingBlockManager;
import net.dries007.tfc.objects.CreativeTabsTFC;
import net.dries007.tfc.objects.blocks.BlockAggregate;
import net.dries007.tfc.objects.blocks.BlockBloom;
import net.dries007.tfc.objects.blocks.BlockCharcoalPile;
import net.dries007.tfc.objects.blocks.BlockDebug;
import net.dries007.tfc.objects.blocks.BlockDecorativeStone;
import net.dries007.tfc.objects.blocks.BlockFireBrick;
import net.dries007.tfc.objects.blocks.BlockFireClay;
import net.dries007.tfc.objects.blocks.BlockFlowerPotTFC;
import net.dries007.tfc.objects.blocks.BlockFluidHotWater;
import net.dries007.tfc.objects.blocks.BlockFluidTFC;
import net.dries007.tfc.objects.blocks.BlockFluidWater;
import net.dries007.tfc.objects.blocks.BlockIceTFC;
import net.dries007.tfc.objects.blocks.BlockLargeVessel;
import net.dries007.tfc.objects.blocks.BlockMolten;
import net.dries007.tfc.objects.blocks.BlockNestBox;
import net.dries007.tfc.objects.blocks.BlockPeat;
import net.dries007.tfc.objects.blocks.BlockPeatGrass;
import net.dries007.tfc.objects.blocks.BlockPlacedHide;
import net.dries007.tfc.objects.blocks.BlockPlacedItem;
import net.dries007.tfc.objects.blocks.BlockPlacedItemFlat;
import net.dries007.tfc.objects.blocks.BlockPowderKeg;
import net.dries007.tfc.objects.blocks.BlockSlabTFC;
import net.dries007.tfc.objects.blocks.BlockSnowTFC;
import net.dries007.tfc.objects.blocks.BlockStairsTFC;
import net.dries007.tfc.objects.blocks.BlockThatch;
import net.dries007.tfc.objects.blocks.BlockThatchBed;
import net.dries007.tfc.objects.blocks.BlockTorchTFC;
import net.dries007.tfc.objects.blocks.agriculture.BlockBerryBush;
import net.dries007.tfc.objects.blocks.agriculture.BlockCropDead;
import net.dries007.tfc.objects.blocks.agriculture.BlockCropTFC;
import net.dries007.tfc.objects.blocks.agriculture.BlockFruitTreeBranch;
import net.dries007.tfc.objects.blocks.agriculture.BlockFruitTreeLeaves;
import net.dries007.tfc.objects.blocks.agriculture.BlockFruitTreeSapling;
import net.dries007.tfc.objects.blocks.agriculture.BlockFruitTreeTrunk;
import net.dries007.tfc.objects.blocks.devices.BlockBellows;
import net.dries007.tfc.objects.blocks.devices.BlockBlastFurnace;
import net.dries007.tfc.objects.blocks.devices.BlockBloomery;
import net.dries007.tfc.objects.blocks.devices.BlockCharcoalForge;
import net.dries007.tfc.objects.blocks.devices.BlockCrucible;
import net.dries007.tfc.objects.blocks.devices.BlockFirePit;
import net.dries007.tfc.objects.blocks.devices.BlockPitKiln;
import net.dries007.tfc.objects.blocks.devices.BlockQuern;
import net.dries007.tfc.objects.blocks.devices.BlockSluice;
import net.dries007.tfc.objects.blocks.metal.BlockAnvilTFC;
import net.dries007.tfc.objects.blocks.metal.BlockIngotPile;
import net.dries007.tfc.objects.blocks.metal.BlockMetalLamp;
import net.dries007.tfc.objects.blocks.metal.BlockMetalSheet;
import net.dries007.tfc.objects.blocks.metal.BlockTrapDoorMetalTFC;
import net.dries007.tfc.objects.blocks.plants.BlockFloatingWaterTFC;
import net.dries007.tfc.objects.blocks.plants.BlockPlantTFC;
import net.dries007.tfc.objects.blocks.stone.BlockButtonStoneTFC;
import net.dries007.tfc.objects.blocks.stone.BlockOreTFC;
import net.dries007.tfc.objects.blocks.stone.BlockPressurePlateTFC;
import net.dries007.tfc.objects.blocks.stone.BlockRockSmooth;
import net.dries007.tfc.objects.blocks.stone.BlockRockVariant;
import net.dries007.tfc.objects.blocks.stone.BlockWallTFC;
import net.dries007.tfc.objects.blocks.stone.BlockWoodPressurePlateTFC;
import net.dries007.tfc.objects.blocks.wood.BlockBarrel;
import net.dries007.tfc.objects.blocks.wood.BlockBookshelfTFC;
import net.dries007.tfc.objects.blocks.wood.BlockButtonWoodTFC;
import net.dries007.tfc.objects.blocks.wood.BlockChestTFC;
import net.dries007.tfc.objects.blocks.wood.BlockDoorTFC;
import net.dries007.tfc.objects.blocks.wood.BlockFenceGateTFC;
import net.dries007.tfc.objects.blocks.wood.BlockFenceTFC;
import net.dries007.tfc.objects.blocks.wood.BlockLeavesTFC;
import net.dries007.tfc.objects.blocks.wood.BlockLogPile;
import net.dries007.tfc.objects.blocks.wood.BlockLogTFC;
import net.dries007.tfc.objects.blocks.wood.BlockLoom;
import net.dries007.tfc.objects.blocks.wood.BlockPlanksTFC;
import net.dries007.tfc.objects.blocks.wood.BlockSaplingTFC;
import net.dries007.tfc.objects.blocks.wood.BlockSupport;
import net.dries007.tfc.objects.blocks.wood.BlockToolRack;
import net.dries007.tfc.objects.blocks.wood.BlockTrapDoorWoodTFC;
import net.dries007.tfc.objects.blocks.wood.BlockWorkbenchTFC;
import net.dries007.tfc.objects.fluids.FluidsTFC;
import net.dries007.tfc.objects.fluids.properties.FluidWrapper;
import net.dries007.tfc.objects.items.itemblock.ItemBlockBarrel;
import net.dries007.tfc.objects.items.itemblock.ItemBlockCrucible;
import net.dries007.tfc.objects.items.itemblock.ItemBlockFloatingWaterTFC;
import net.dries007.tfc.objects.items.itemblock.ItemBlockHeat;
import net.dries007.tfc.objects.items.itemblock.ItemBlockLargeVessel;
import net.dries007.tfc.objects.items.itemblock.ItemBlockPlant;
import net.dries007.tfc.objects.items.itemblock.ItemBlockPowderKeg;
import net.dries007.tfc.objects.items.itemblock.ItemBlockSaplingTFC;
import net.dries007.tfc.objects.items.itemblock.ItemBlockSluice;
import net.dries007.tfc.objects.items.itemblock.ItemBlockTFC;
import net.dries007.tfc.objects.te.TEAnvilTFC;
import net.dries007.tfc.objects.te.TEBarrel;
import net.dries007.tfc.objects.te.TEBellows;
import net.dries007.tfc.objects.te.TEBlastFurnace;
import net.dries007.tfc.objects.te.TEBloom;
import net.dries007.tfc.objects.te.TEBloomery;
import net.dries007.tfc.objects.te.TECharcoalForge;
import net.dries007.tfc.objects.te.TEChestTFC;
import net.dries007.tfc.objects.te.TECropBase;
import net.dries007.tfc.objects.te.TECropSpreading;
import net.dries007.tfc.objects.te.TECrucible;
import net.dries007.tfc.objects.te.TEFirePit;
import net.dries007.tfc.objects.te.TEIngotPile;
import net.dries007.tfc.objects.te.TELamp;
import net.dries007.tfc.objects.te.TELargeVessel;
import net.dries007.tfc.objects.te.TELogPile;
import net.dries007.tfc.objects.te.TELoom;
import net.dries007.tfc.objects.te.TEMetalSheet;
import net.dries007.tfc.objects.te.TENestBox;
import net.dries007.tfc.objects.te.TEPitKiln;
import net.dries007.tfc.objects.te.TEPlacedHide;
import net.dries007.tfc.objects.te.TEPlacedItem;
import net.dries007.tfc.objects.te.TEPlacedItemFlat;
import net.dries007.tfc.objects.te.TEPowderKeg;
import net.dries007.tfc.objects.te.TEQuern;
import net.dries007.tfc.objects.te.TESluice;
import net.dries007.tfc.objects.te.TETickCounter;
import net.dries007.tfc.objects.te.TEToolRack;
import net.dries007.tfc.util.Helpers;
import net.dries007.tfc.util.agriculture.BerryBush;
import net.dries007.tfc.util.agriculture.Crop;
import net.dries007.tfc.util.agriculture.FruitTree;
import net.minecraft.block.Block;
import net.minecraft.block.BlockGravel;
import net.minecraft.block.material.MapColor;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.init.Blocks;
import net.minecraft.item.EnumDyeColor;
import net.minecraft.item.ItemBlock;
import net.minecraft.tileentity.TileEntity;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.fluids.BlockFluidBase;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.eventhandler.EventPriority;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.registry.GameRegistry;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.IForgeRegistryEntry;

@Mod.EventBusSubscriber(modid="tfc")
@GameRegistry.ObjectHolder(value="tfc")
public final class BlocksTFC {
    @GameRegistry.ObjectHolder(value="ceramics/fired/large_vessel")
    public static final BlockLargeVessel FIRED_LARGE_VESSEL = (BlockLargeVessel)Helpers.getNull();
    @GameRegistry.ObjectHolder(value="alabaster/bricks/plain")
    public static final BlockDecorativeStone ALABASTER_BRICKS_PLAIN = (BlockDecorativeStone)Helpers.getNull();
    @GameRegistry.ObjectHolder(value="alabaster/polished/plain")
    public static final BlockDecorativeStone ALABASTER_POLISHED_PLAIN = (BlockDecorativeStone)Helpers.getNull();
    @GameRegistry.ObjectHolder(value="alabaster/raw/plain")
    public static final BlockDecorativeStone ALABASTER_RAW_PLAIN = (BlockDecorativeStone)Helpers.getNull();
    public static final BlockDebug DEBUG = (BlockDebug)((Object)Helpers.getNull());
    public static final BlockPeat PEAT = (BlockPeat)((Object)Helpers.getNull());
    public static final BlockPeat PEAT_GRASS = (BlockPeat)((Object)Helpers.getNull());
    public static final BlockFirePit FIREPIT = (BlockFirePit)Helpers.getNull();
    public static final BlockThatch THATCH = (BlockThatch)((Object)Helpers.getNull());
    public static final BlockThatchBed THATCH_BED = (BlockThatchBed)((Object)Helpers.getNull());
    public static final BlockPitKiln PIT_KILN = (BlockPitKiln)Helpers.getNull();
    public static final BlockPlacedItemFlat PLACED_ITEM_FLAT = (BlockPlacedItemFlat)((Object)Helpers.getNull());
    public static final BlockPlacedItem PLACED_ITEM = (BlockPlacedItem)((Object)Helpers.getNull());
    public static final BlockPlacedHide PLACED_HIDE = (BlockPlacedHide)((Object)Helpers.getNull());
    public static final BlockCharcoalPile CHARCOAL_PILE = (BlockCharcoalPile)Helpers.getNull();
    public static final BlockNestBox NEST_BOX = (BlockNestBox)((Object)Helpers.getNull());
    public static final BlockLogPile LOG_PILE = (BlockLogPile)Helpers.getNull();
    public static final BlockIngotPile INGOT_PILE = (BlockIngotPile)((Object)Helpers.getNull());
    public static final BlockCharcoalForge CHARCOAL_FORGE = (BlockCharcoalForge)Helpers.getNull();
    public static final BlockCrucible CRUCIBLE = (BlockCrucible)Helpers.getNull();
    public static final BlockMolten MOLTEN = (BlockMolten)Helpers.getNull();
    public static final BlockBlastFurnace BLAST_FURNACE = (BlockBlastFurnace)Helpers.getNull();
    public static final BlockBloom BLOOM = (BlockBloom)((Object)Helpers.getNull());
    public static final BlockBloomery BLOOMERY = (BlockBloomery)Helpers.getNull();
    public static final BlockQuern QUERN = (BlockQuern)Helpers.getNull();
    public static final BlockIceTFC SEA_ICE = (BlockIceTFC)Helpers.getNull();
    public static final BlockPowderKeg POWDERKEG = (BlockPowderKeg)Helpers.getNull();
    public static final BlockGravel AGGREGATE = (BlockGravel)Helpers.getNull();
    public static final Block FIRE_BRICKS = (Block)Helpers.getNull();
    private static ImmutableList<ItemBlock> allNormalItemBlocks;
    private static ImmutableList<ItemBlock> allInventoryItemBlocks;
    private static ImmutableList<ItemBlockBarrel> allBarrelItemBlocks;
    private static ImmutableList<BlockFluidBase> allFluidBlocks;
    private static ImmutableList<BlockRockVariant> allBlockRockVariants;
    private static ImmutableList<BlockOreTFC> allOreBlocks;
    private static ImmutableList<BlockWallTFC> allWallBlocks;
    private static ImmutableList<BlockLogTFC> allLogBlocks;
    private static ImmutableList<BlockLeavesTFC> allLeafBlocks;
    private static ImmutableList<BlockFenceGateTFC> allFenceGateBlocks;
    private static ImmutableList<BlockSaplingTFC> allSaplingBlocks;
    private static ImmutableList<BlockDoorTFC> allDoorBlocks;
    private static ImmutableList<BlockTrapDoorWoodTFC> allTrapDoorWoodBlocks;
    private static ImmutableList<BlockTrapDoorMetalTFC> allTrapDoorMetalBlocks;
    private static ImmutableList<BlockStairsTFC> allStairsBlocks;
    private static ImmutableList<BlockSlabTFC.Half> allSlabBlocks;
    private static ImmutableList<BlockChestTFC> allChestBlocks;
    private static ImmutableList<BlockAnvilTFC> allAnvils;
    private static ImmutableList<BlockMetalSheet> allSheets;
    private static ImmutableList<BlockMetalLamp> allLamps;
    private static ImmutableList<BlockToolRack> allToolRackBlocks;
    private static ImmutableList<BlockCropTFC> allCropBlocks;
    private static ImmutableList<BlockCropDead> allDeadCropBlocks;
    private static ImmutableList<BlockPlantTFC> allPlantBlocks;
    private static ImmutableList<BlockPlantTFC> allGrassBlocks;
    private static ImmutableList<BlockLoom> allLoomBlocks;
    private static ImmutableList<BlockSupport> allSupportBlocks;
    private static ImmutableList<BlockFlowerPotTFC> allFlowerPots;
    private static ImmutableList<BlockFruitTreeSapling> allFruitTreeSaplingBlocks;
    private static ImmutableList<BlockFruitTreeTrunk> allFruitTreeTrunkBlocks;
    private static ImmutableList<BlockFruitTreeBranch> allFruitTreeBranchBlocks;
    private static ImmutableList<BlockFruitTreeLeaves> allFruitTreeLeavesBlocks;
    private static ImmutableList<BlockBerryBush> allBerryBushBlocks;

    public static ImmutableList<ItemBlock> getAllNormalItemBlocks() {
        return allNormalItemBlocks;
    }

    public static ImmutableList<ItemBlock> getAllInventoryItemBlocks() {
        return allInventoryItemBlocks;
    }

    public static ImmutableList<ItemBlockBarrel> getAllBarrelItemBlocks() {
        return allBarrelItemBlocks;
    }

    public static ImmutableList<BlockFluidBase> getAllFluidBlocks() {
        return allFluidBlocks;
    }

    public static ImmutableList<BlockRockVariant> getAllBlockRockVariants() {
        return allBlockRockVariants;
    }

    public static ImmutableList<BlockLogTFC> getAllLogBlocks() {
        return allLogBlocks;
    }

    public static ImmutableList<BlockLeavesTFC> getAllLeafBlocks() {
        return allLeafBlocks;
    }

    public static ImmutableList<BlockOreTFC> getAllOreBlocks() {
        return allOreBlocks;
    }

    public static ImmutableList<BlockFenceGateTFC> getAllFenceGateBlocks() {
        return allFenceGateBlocks;
    }

    public static ImmutableList<BlockWallTFC> getAllWallBlocks() {
        return allWallBlocks;
    }

    public static ImmutableList<BlockSaplingTFC> getAllSaplingBlocks() {
        return allSaplingBlocks;
    }

    public static ImmutableList<BlockDoorTFC> getAllDoorBlocks() {
        return allDoorBlocks;
    }

    public static ImmutableList<BlockTrapDoorWoodTFC> getAllTrapDoorWoodBlocks() {
        return allTrapDoorWoodBlocks;
    }

    public static ImmutableList<BlockTrapDoorMetalTFC> getAllTrapDoorMetalBlocks() {
        return allTrapDoorMetalBlocks;
    }

    public static ImmutableList<BlockStairsTFC> getAllStairsBlocks() {
        return allStairsBlocks;
    }

    public static ImmutableList<BlockSlabTFC.Half> getAllSlabBlocks() {
        return allSlabBlocks;
    }

    public static ImmutableList<BlockChestTFC> getAllChestBlocks() {
        return allChestBlocks;
    }

    public static ImmutableList<BlockAnvilTFC> getAllAnvils() {
        return allAnvils;
    }

    public static ImmutableList<BlockMetalSheet> getAllSheets() {
        return allSheets;
    }

    public static ImmutableList<BlockMetalLamp> getAllLamps() {
        return allLamps;
    }

    public static ImmutableList<BlockToolRack> getAllToolRackBlocks() {
        return allToolRackBlocks;
    }

    public static ImmutableList<BlockCropTFC> getAllCropBlocks() {
        return allCropBlocks;
    }

    public static ImmutableList<BlockCropDead> getAllDeadCropBlocks() {
        return allDeadCropBlocks;
    }

    public static ImmutableList<BlockPlantTFC> getAllPlantBlocks() {
        return allPlantBlocks;
    }

    public static ImmutableList<BlockPlantTFC> getAllGrassBlocks() {
        return allGrassBlocks;
    }

    public static ImmutableList<BlockLoom> getAllLoomBlocks() {
        return allLoomBlocks;
    }

    public static ImmutableList<BlockSupport> getAllSupportBlocks() {
        return allSupportBlocks;
    }

    public static ImmutableList<BlockFlowerPotTFC> getAllFlowerPots() {
        return allFlowerPots;
    }

    public static ImmutableList<BlockFruitTreeSapling> getAllFruitTreeSaplingBlocks() {
        return allFruitTreeSaplingBlocks;
    }

    public static ImmutableList<BlockFruitTreeTrunk> getAllFruitTreeTrunkBlocks() {
        return allFruitTreeTrunkBlocks;
    }

    public static ImmutableList<BlockFruitTreeBranch> getAllFruitTreeBranchBlocks() {
        return allFruitTreeBranchBlocks;
    }

    public static ImmutableList<BlockFruitTreeLeaves> getAllFruitTreeLeavesBlocks() {
        return allFruitTreeLeavesBlocks;
    }

    public static ImmutableList<BlockBerryBush> getAllBerryBushBlocks() {
        return allBerryBushBlocks;
    }

    @SubscribeEvent
    public static void registerBlocks(RegistryEvent.Register<Block> event) {
        FluidsTFC.registerFluids();
        IForgeRegistry r = event.getRegistry();
        ImmutableList.Builder normalItemBlocks = ImmutableList.builder();
        ImmutableList.Builder inventoryItemBlocks = ImmutableList.builder();
        normalItemBlocks.add((Object)new ItemBlockTFC(BlocksTFC.register((IForgeRegistry<Block>)r, "debug", new BlockDebug(), CreativeTabsTFC.CT_MISC)));
        normalItemBlocks.add((Object)new ItemBlockTFC((Block)BlocksTFC.register((IForgeRegistry<Block>)r, "aggregate", new BlockAggregate(), CreativeTabsTFC.CT_ROCK_BLOCKS)));
        normalItemBlocks.add((Object)new ItemBlockTFC(BlocksTFC.register((IForgeRegistry<Block>)r, "fire_clay_block", new BlockFireClay(), CreativeTabsTFC.CT_ROCK_BLOCKS)));
        normalItemBlocks.add((Object)new ItemBlockTFC(BlocksTFC.register((IForgeRegistry<Block>)r, "peat", new BlockPeat(Material.field_151578_c), CreativeTabsTFC.CT_ROCK_BLOCKS)));
        normalItemBlocks.add((Object)new ItemBlockTFC(BlocksTFC.register((IForgeRegistry<Block>)r, "peat_grass", new BlockPeatGrass(Material.field_151577_b), CreativeTabsTFC.CT_ROCK_BLOCKS)));
        normalItemBlocks.add((Object)new ItemBlockTFC(BlocksTFC.register((IForgeRegistry<Block>)r, "thatch", new BlockThatch(), CreativeTabsTFC.CT_DECORATIONS)));
        normalItemBlocks.add((Object)new ItemBlockTFC(BlocksTFC.register((IForgeRegistry<Block>)r, "fire_bricks", new BlockFireBrick(), CreativeTabsTFC.CT_DECORATIONS)));
        normalItemBlocks.add((Object)new ItemBlockTFC(BlocksTFC.register((IForgeRegistry<Block>)r, "quern", new BlockQuern(), CreativeTabsTFC.CT_MISC)));
        normalItemBlocks.add((Object)new ItemBlockCrucible(BlocksTFC.register((IForgeRegistry<Block>)r, "crucible", new BlockCrucible(), CreativeTabsTFC.CT_MISC)));
        normalItemBlocks.add((Object)new ItemBlockTFC(BlocksTFC.register((IForgeRegistry<Block>)r, "blast_furnace", new BlockBlastFurnace(), CreativeTabsTFC.CT_MISC)));
        inventoryItemBlocks.add((Object)new ItemBlockTFC(BlocksTFC.register((IForgeRegistry<Block>)r, "bellows", new BlockBellows(), CreativeTabsTFC.CT_MISC)));
        inventoryItemBlocks.add((Object)new ItemBlockTFC((Block)BlocksTFC.register((IForgeRegistry<Block>)r, "bloomery", new BlockBloomery(), CreativeTabsTFC.CT_MISC)));
        inventoryItemBlocks.add((Object)new ItemBlockTFC(BlocksTFC.register((IForgeRegistry<Block>)r, "nest_box", new BlockNestBox(), CreativeTabsTFC.CT_MISC)));
        inventoryItemBlocks.add((Object)new ItemBlockSluice((Block)BlocksTFC.register((IForgeRegistry<Block>)r, "sluice", new BlockSluice(), CreativeTabsTFC.CT_MISC)));
        normalItemBlocks.add((Object)new ItemBlockTFC((Block)BlocksTFC.register((IForgeRegistry<Block>)r, "sea_ice", new BlockIceTFC(FluidsTFC.SALT_WATER.get()), CreativeTabsTFC.CT_MISC)));
        normalItemBlocks.add((Object)new ItemBlockLargeVessel(BlocksTFC.register((IForgeRegistry<Block>)r, "ceramics/fired/large_vessel", new BlockLargeVessel(), CreativeTabsTFC.CT_POTTERY)));
        normalItemBlocks.add((Object)new ItemBlockPowderKeg(BlocksTFC.register((IForgeRegistry<Block>)r, "powderkeg", new BlockPowderKeg(), CreativeTabsTFC.CT_WOOD)));
        normalItemBlocks.add((Object)new ItemBlockTFC(BlocksTFC.register((IForgeRegistry<Block>)r, "alabaster/raw/plain", new BlockDecorativeStone(MapColor.field_151666_j), CreativeTabsTFC.CT_DECORATIONS)));
        normalItemBlocks.add((Object)new ItemBlockTFC(BlocksTFC.register((IForgeRegistry<Block>)r, "alabaster/polished/plain", new BlockDecorativeStone(MapColor.field_151666_j), CreativeTabsTFC.CT_DECORATIONS)));
        normalItemBlocks.add((Object)new ItemBlockTFC(BlocksTFC.register((IForgeRegistry<Block>)r, "alabaster/bricks/plain", new BlockDecorativeStone(MapColor.field_151666_j), CreativeTabsTFC.CT_DECORATIONS)));
        for (EnumDyeColor dyeColor : EnumDyeColor.values()) {
            BlockDecorativeStone polished = new BlockDecorativeStone(MapColor.func_193558_a((EnumDyeColor)dyeColor));
            BlockDecorativeStone bricks = new BlockDecorativeStone(MapColor.func_193558_a((EnumDyeColor)dyeColor));
            BlockDecorativeStone raw = new BlockDecorativeStone(MapColor.func_193558_a((EnumDyeColor)dyeColor));
            normalItemBlocks.add((Object)new ItemBlockTFC(BlocksTFC.register((IForgeRegistry<Block>)r, "alabaster/polished/" + dyeColor.func_176610_l(), polished, CreativeTabsTFC.CT_DECORATIONS)));
            normalItemBlocks.add((Object)new ItemBlockTFC(BlocksTFC.register((IForgeRegistry<Block>)r, "alabaster/bricks/" + dyeColor.func_176610_l(), bricks, CreativeTabsTFC.CT_DECORATIONS)));
            normalItemBlocks.add((Object)new ItemBlockTFC(BlocksTFC.register((IForgeRegistry<Block>)r, "alabaster/raw/" + dyeColor.func_176610_l(), raw, CreativeTabsTFC.CT_DECORATIONS)));
            BlockDecorativeStone.ALABASTER_POLISHED.put(dyeColor, polished);
            BlockDecorativeStone.ALABASTER_BRICKS.put(dyeColor, bricks);
            BlockDecorativeStone.ALABASTER_RAW.put(dyeColor, raw);
        }
        Object b = ImmutableList.builder();
        b.add((Object[])new BlockFluidBase[]{(BlockFluidBase)BlocksTFC.register((IForgeRegistry<Block>)r, "fluid/hot_water", new BlockFluidHotWater()), (BlockFluidBase)BlocksTFC.register((IForgeRegistry<Block>)r, "fluid/fresh_water", new BlockFluidWater(FluidsTFC.FRESH_WATER.get(), Material.field_151586_h, false)), (BlockFluidBase)BlocksTFC.register((IForgeRegistry<Block>)r, "fluid/salt_water", new BlockFluidWater(FluidsTFC.SALT_WATER.get(), Material.field_151586_h, true))});
        for (FluidWrapper wrapper : FluidsTFC.getAllAlcoholsFluids()) {
            b.add((Object)BlocksTFC.register((IForgeRegistry<Block>)r, "fluid/" + wrapper.get().getName(), new BlockFluidTFC(wrapper.get(), Material.field_151586_h)));
        }
        for (FluidWrapper wrapper : FluidsTFC.getAllOtherFiniteFluids()) {
            b.add((Object)BlocksTFC.register((IForgeRegistry<Block>)r, "fluid/" + wrapper.get().getName(), new BlockFluidTFC(wrapper.get(), Material.field_151586_h)));
        }
        for (FluidWrapper wrapper : FluidsTFC.getAllMetalFluids()) {
            b.add((Object)BlocksTFC.register((IForgeRegistry<Block>)r, "fluid/" + wrapper.get().getName(), new BlockFluidTFC(wrapper.get(), Material.field_151587_i)));
        }
        for (EnumDyeColor color : EnumDyeColor.values()) {
            FluidWrapper wrapper = FluidsTFC.getFluidFromDye(color);
            b.add((Object)BlocksTFC.register((IForgeRegistry<Block>)r, "fluid/" + wrapper.get().getName(), new BlockFluidTFC(wrapper.get(), Material.field_151586_h)));
        }
        allFluidBlocks = b.build();
        b = ImmutableList.builder();
        for (EnumDyeColor type : Rock.Type.values()) {
            for (Rock rock : TFCRegistries.ROCKS.getValuesCollection()) {
                if (type != Rock.Type.ANVIL) {
                    b.add((Object)BlocksTFC.register((IForgeRegistry<Block>)r, type.name().toLowerCase() + "/" + rock.getRegistryName().func_110623_a(), BlockRockVariant.create(rock, (Rock.Type)type), CreativeTabsTFC.CT_ROCK_BLOCKS));
                    continue;
                }
                if (!rock.getRockCategory().hasAnvil()) continue;
                BlocksTFC.register((IForgeRegistry<Block>)r, "anvil/" + rock.getRegistryName().func_110623_a(), BlockRockVariant.create(rock, (Rock.Type)type));
            }
        }
        allBlockRockVariants = b.build();
        allBlockRockVariants.forEach(x -> {
            if (x.getType() == Rock.Type.SAND) {
                normalItemBlocks.add((Object)new ItemBlockHeat((Block)x, 1.0f, 600.0f));
            } else if (x.getType() != Rock.Type.SPIKE && x.getType() != Rock.Type.ANVIL) {
                normalItemBlocks.add((Object)new ItemBlockTFC((Block)x));
            }
        });
        for (Object rock : TFCRegistries.ROCKS.getValuesCollection()) {
            block13: for (Rock.Type type : Rock.Type.values()) {
                FallingBlockManager.Specification spec = type.getFallingSpecification();
                switch (type) {
                    case ANVIL: {
                        if (!((Rock)((Object)rock)).getRockCategory().hasAnvil()) continue block13;
                    }
                    case RAW: {
                        spec = new FallingBlockManager.Specification(spec);
                        spec.setResultingState(BlockRockVariant.get((Rock)((Object)rock), Rock.Type.COBBLE).func_176223_P());
                        FallingBlockManager.registerFallable(BlockRockVariant.get((Rock)((Object)rock), Rock.Type.RAW), spec);
                        continue block13;
                    }
                    case SMOOTH: {
                        spec = new FallingBlockManager.Specification(spec);
                        spec.setResultingState(BlockRockVariant.get((Rock)((Object)rock), Rock.Type.COBBLE).func_176223_P());
                        FallingBlockManager.registerFallable(BlockRockVariant.get((Rock)((Object)rock), Rock.Type.SMOOTH).func_176223_P().func_177226_a((IProperty)BlockRockSmooth.CAN_FALL, (Comparable)Boolean.valueOf(true)), spec);
                        continue block13;
                    }
                    default: {
                        Rock.Type nonGrassType = type.getNonGrassVersion();
                        if (nonGrassType != type) {
                            spec = new FallingBlockManager.Specification(spec);
                            spec.setResultingState(BlockRockVariant.get((Rock)((Object)rock), nonGrassType).func_176223_P());
                        }
                        FallingBlockManager.registerFallable(BlockRockVariant.get((Rock)((Object)rock), type), spec);
                    }
                }
            }
        }
        b = ImmutableList.builder();
        for (Ore ore : TFCRegistries.ORES.getValuesCollection()) {
            for (Rock rock : TFCRegistries.ROCKS.getValuesCollection()) {
                b.add((Object)BlocksTFC.register((IForgeRegistry<Block>)r, ("ore/" + ore.getRegistryName().func_110623_a() + "/" + rock.getRegistryName().func_110623_a()).toLowerCase(), new BlockOreTFC(ore, rock), CreativeTabsTFC.CT_ROCK_BLOCKS));
            }
        }
        allOreBlocks = b.build();
        allOreBlocks.forEach(x -> normalItemBlocks.add((Object)new ItemBlockTFC((Block)x)));
        ImmutableList.Builder logs = ImmutableList.builder();
        ImmutableList.Builder leaves = ImmutableList.builder();
        ImmutableList.Builder fenceGates = ImmutableList.builder();
        Rock.Type[] saplings = ImmutableList.builder();
        ImmutableList.Builder doors = ImmutableList.builder();
        ImmutableList.Builder trapDoors = ImmutableList.builder();
        ImmutableList.Builder chests = ImmutableList.builder();
        ImmutableList.Builder toolRacks = ImmutableList.builder();
        ImmutableList.Builder barrelItems = ImmutableList.builder();
        ImmutableList.Builder plants = ImmutableList.builder();
        ImmutableList.Builder looms = ImmutableList.builder();
        ImmutableList.Builder supports = ImmutableList.builder();
        for (Tree wood : TFCRegistries.TREES.getValuesCollection()) {
            normalItemBlocks.add((Object)new ItemBlockTFC(BlocksTFC.register((IForgeRegistry<Block>)r, "wood/bookshelf/" + wood.getRegistryName().func_110623_a(), new BlockBookshelfTFC(wood), CreativeTabsTFC.CT_DECORATIONS)));
        }
        for (Tree wood : TFCRegistries.TREES.getValuesCollection()) {
            normalItemBlocks.add((Object)new ItemBlockTFC((Block)BlocksTFC.register((IForgeRegistry<Block>)r, "wood/workbench/" + wood.getRegistryName().func_110623_a(), new BlockWorkbenchTFC(wood), CreativeTabsTFC.CT_DECORATIONS)));
        }
        for (Tree wood : TFCRegistries.TREES.getValuesCollection()) {
            inventoryItemBlocks.add((Object)new ItemBlockTFC((Block)BlocksTFC.register((IForgeRegistry<Block>)r, "wood/fence/" + wood.getRegistryName().func_110623_a(), new BlockFenceTFC(wood), CreativeTabsTFC.CT_DECORATIONS)));
        }
        for (Tree wood : TFCRegistries.TREES.getValuesCollection()) {
            inventoryItemBlocks.add((Object)new ItemBlockTFC((Block)BlocksTFC.register((IForgeRegistry<Block>)r, "wood/button/" + wood.getRegistryName().func_110623_a(), new BlockButtonWoodTFC(wood), CreativeTabsTFC.CT_DECORATIONS)));
        }
        for (Tree wood : TFCRegistries.TREES.getValuesCollection()) {
            inventoryItemBlocks.add((Object)new ItemBlockTFC((Block)BlocksTFC.register((IForgeRegistry<Block>)r, "wood/pressure_plate/" + wood.getRegistryName().func_110623_a().toLowerCase(), new BlockWoodPressurePlateTFC(wood), CreativeTabsTFC.CT_DECORATIONS)));
        }
        for (Tree wood : TFCRegistries.TREES.getValuesCollection()) {
            normalItemBlocks.add((Object)new ItemBlockTFC(BlocksTFC.register((IForgeRegistry<Block>)r, "wood/planks/" + wood.getRegistryName().func_110623_a(), new BlockPlanksTFC(wood), CreativeTabsTFC.CT_WOOD)));
            logs.add((Object)BlocksTFC.register((IForgeRegistry<Block>)r, "wood/log/" + wood.getRegistryName().func_110623_a(), new BlockLogTFC(wood), CreativeTabsTFC.CT_WOOD));
            leaves.add((Object)BlocksTFC.register((IForgeRegistry<Block>)r, "wood/leaves/" + wood.getRegistryName().func_110623_a(), new BlockLeavesTFC(wood), CreativeTabsTFC.CT_WOOD));
            fenceGates.add((Object)BlocksTFC.register((IForgeRegistry<Block>)r, "wood/fence_gate/" + wood.getRegistryName().func_110623_a(), new BlockFenceGateTFC(wood), CreativeTabsTFC.CT_DECORATIONS));
            saplings.add((Object)BlocksTFC.register((IForgeRegistry<Block>)r, "wood/sapling/" + wood.getRegistryName().func_110623_a(), new BlockSaplingTFC(wood), CreativeTabsTFC.CT_WOOD));
            doors.add((Object)BlocksTFC.register((IForgeRegistry<Block>)r, "wood/door/" + wood.getRegistryName().func_110623_a(), new BlockDoorTFC(wood), CreativeTabsTFC.CT_DECORATIONS));
            trapDoors.add((Object)BlocksTFC.register((IForgeRegistry<Block>)r, "wood/trapdoor/" + wood.getRegistryName().func_110623_a(), new BlockTrapDoorWoodTFC(wood), CreativeTabsTFC.CT_DECORATIONS));
            chests.add((Object)BlocksTFC.register((IForgeRegistry<Block>)r, "wood/chest/" + wood.getRegistryName().func_110623_a(), new BlockChestTFC(BlockChestTFC.TFCBASIC, wood), CreativeTabsTFC.CT_DECORATIONS));
            chests.add((Object)BlocksTFC.register((IForgeRegistry<Block>)r, "wood/chest_trap/" + wood.getRegistryName().func_110623_a(), new BlockChestTFC(BlockChestTFC.TFCTRAP, wood), CreativeTabsTFC.CT_DECORATIONS));
            toolRacks.add((Object)BlocksTFC.register((IForgeRegistry<Block>)r, "wood/tool_rack/" + wood.getRegistryName().func_110623_a(), new BlockToolRack(wood), CreativeTabsTFC.CT_DECORATIONS));
            barrelItems.add((Object)new ItemBlockBarrel(BlocksTFC.register((IForgeRegistry<Block>)r, "wood/barrel/" + wood.getRegistryName().func_110623_a(), new BlockBarrel(), CreativeTabsTFC.CT_DECORATIONS)));
            looms.add((Object)BlocksTFC.register((IForgeRegistry<Block>)r, "wood/loom/" + wood.getRegistryName().func_110623_a(), new BlockLoom(wood), CreativeTabsTFC.CT_WOOD));
            supports.add((Object)BlocksTFC.register((IForgeRegistry<Block>)r, "wood/support/" + wood.getRegistryName().func_110623_a(), new BlockSupport(wood), CreativeTabsTFC.CT_WOOD));
        }
        allLogBlocks = logs.build();
        allLeafBlocks = leaves.build();
        allFenceGateBlocks = fenceGates.build();
        allSaplingBlocks = saplings.build();
        allDoorBlocks = doors.build();
        allTrapDoorWoodBlocks = trapDoors.build();
        allChestBlocks = chests.build();
        allToolRackBlocks = toolRacks.build();
        allLoomBlocks = looms.build();
        allSupportBlocks = supports.build();
        allBarrelItemBlocks = barrelItems.build();
        allLeafBlocks.forEach(x -> normalItemBlocks.add((Object)new ItemBlockTFC((Block)x)));
        allFenceGateBlocks.forEach(x -> inventoryItemBlocks.add((Object)new ItemBlockTFC((Block)x)));
        allSaplingBlocks.forEach(x -> inventoryItemBlocks.add((Object)new ItemBlockSaplingTFC((BlockSaplingTFC)x)));
        allTrapDoorWoodBlocks.forEach(x -> inventoryItemBlocks.add((Object)new ItemBlockTFC((Block)x)));
        allChestBlocks.forEach(x -> normalItemBlocks.add((Object)new ItemBlockTFC((Block)x)));
        allToolRackBlocks.forEach(x -> normalItemBlocks.add((Object)new ItemBlockTFC((Block)x)));
        allLoomBlocks.forEach(x -> normalItemBlocks.add((Object)new ItemBlockTFC((Block)x)));
        allSupportBlocks.forEach(x -> normalItemBlocks.add((Object)new ItemBlockTFC((Block)x)));
        b = ImmutableList.builder();
        ImmutableList.Builder stairs = new ImmutableList.Builder();
        ImmutableList.Builder slab = new ImmutableList.Builder();
        for (Object type : new Rock.Type[]{Rock.Type.SMOOTH, Rock.Type.COBBLE, Rock.Type.BRICKS}) {
            for (Rock rock : TFCRegistries.ROCKS.getValuesCollection()) {
                b.add((Object)BlocksTFC.register((IForgeRegistry<Block>)r, ("wall/" + ((Enum)type).name() + "/" + rock.getRegistryName().func_110623_a()).toLowerCase(), new BlockWallTFC(BlockRockVariant.get(rock, (Rock.Type)((Object)type))), CreativeTabsTFC.CT_DECORATIONS));
            }
        }
        for (Object type : new Rock.Type[]{Rock.Type.SMOOTH, Rock.Type.COBBLE, Rock.Type.BRICKS}) {
            for (Rock rock : TFCRegistries.ROCKS.getValuesCollection()) {
                stairs.add((Object)BlocksTFC.register((IForgeRegistry<Block>)r, "stairs/" + (((Enum)type).name() + "/" + rock.getRegistryName().func_110623_a()).toLowerCase(), new BlockStairsTFC(rock, (Rock.Type)((Object)type)), CreativeTabsTFC.CT_DECORATIONS));
            }
        }
        for (Tree wood : TFCRegistries.TREES.getValuesCollection()) {
            stairs.add((Object)BlocksTFC.register((IForgeRegistry<Block>)r, "stairs/wood/" + wood.getRegistryName().func_110623_a(), new BlockStairsTFC(wood), CreativeTabsTFC.CT_DECORATIONS));
        }
        for (Object type : new Rock.Type[]{Rock.Type.SMOOTH, Rock.Type.COBBLE, Rock.Type.BRICKS}) {
            for (Rock rock : TFCRegistries.ROCKS.getValuesCollection()) {
                BlocksTFC.register((IForgeRegistry<Block>)r, "double_slab/" + (((Enum)type).name() + "/" + rock.getRegistryName().func_110623_a()).toLowerCase(), new BlockSlabTFC.Double(rock, (Rock.Type)((Object)type)));
            }
        }
        for (Tree wood : TFCRegistries.TREES.getValuesCollection()) {
            BlocksTFC.register((IForgeRegistry<Block>)r, "double_slab/wood/" + wood.getRegistryName().func_110623_a(), new BlockSlabTFC.Double(wood));
        }
        for (Object type : new Rock.Type[]{Rock.Type.SMOOTH, Rock.Type.COBBLE, Rock.Type.BRICKS}) {
            for (Rock rock : TFCRegistries.ROCKS.getValuesCollection()) {
                slab.add((Object)BlocksTFC.register((IForgeRegistry<Block>)r, "slab/" + (((Enum)type).name() + "/" + rock.getRegistryName().func_110623_a()).toLowerCase(), new BlockSlabTFC.Half(rock, (Rock.Type)((Object)type)), CreativeTabsTFC.CT_DECORATIONS));
            }
        }
        for (Tree wood : TFCRegistries.TREES.getValuesCollection()) {
            slab.add((Object)BlocksTFC.register((IForgeRegistry<Block>)r, "slab/wood/" + wood.getRegistryName().func_110623_a(), new BlockSlabTFC.Half(wood), CreativeTabsTFC.CT_DECORATIONS));
        }
        for (Rock rock : TFCRegistries.ROCKS.getValuesCollection()) {
            inventoryItemBlocks.add((Object)new ItemBlockTFC((Block)BlocksTFC.register((IForgeRegistry<Block>)r, "stone/button/" + rock.getRegistryName().func_110623_a().toLowerCase(), new BlockButtonStoneTFC(rock), CreativeTabsTFC.CT_DECORATIONS)));
            inventoryItemBlocks.add((Object)new ItemBlockTFC((Block)BlocksTFC.register((IForgeRegistry<Block>)r, "stone/pressure_plate/" + rock.getRegistryName().func_110623_a().toLowerCase(), new BlockPressurePlateTFC(rock), CreativeTabsTFC.CT_DECORATIONS)));
        }
        allWallBlocks = b.build();
        allStairsBlocks = stairs.build();
        allSlabBlocks = slab.build();
        allWallBlocks.forEach(x -> inventoryItemBlocks.add((Object)new ItemBlockTFC((Block)x)));
        allStairsBlocks.forEach(x -> normalItemBlocks.add((Object)new ItemBlockTFC((Block)x)));
        ImmutableList.Builder anvils = ImmutableList.builder();
        Crop[] sheets = ImmutableList.builder();
        ImmutableList.Builder lamps = ImmutableList.builder();
        ImmutableList.Builder metalTrapdoors = ImmutableList.builder();
        for (Metal metal : TFCRegistries.METALS.getValuesCollection()) {
            if (Metal.ItemType.ANVIL.hasType(metal)) {
                anvils.add((Object)BlocksTFC.register((IForgeRegistry<Block>)r, "anvil/" + metal.getRegistryName().func_110623_a(), new BlockAnvilTFC(metal), CreativeTabsTFC.CT_METAL));
            }
            if (Metal.ItemType.SHEET.hasType(metal)) {
                sheets.add((Object)BlocksTFC.register((IForgeRegistry<Block>)r, "sheet/" + metal.getRegistryName().func_110623_a(), new BlockMetalSheet(metal), CreativeTabsTFC.CT_METAL));
                metalTrapdoors.add((Object)BlocksTFC.register((IForgeRegistry<Block>)r, "trapdoor/" + metal.getRegistryName().func_110623_a(), new BlockTrapDoorMetalTFC(metal), CreativeTabsTFC.CT_METAL));
            }
            if (!Metal.ItemType.LAMP.hasType(metal)) continue;
            lamps.add((Object)BlocksTFC.register((IForgeRegistry<Block>)r, "lamp/" + metal.getRegistryName().func_110623_a(), new BlockMetalLamp(metal), CreativeTabsTFC.CT_METAL));
        }
        allAnvils = anvils.build();
        allSheets = sheets.build();
        allLamps = lamps.build();
        allTrapDoorMetalBlocks = metalTrapdoors.build();
        b = ImmutableList.builder();
        for (FruitTree[] crop : Crop.values()) {
            b.add((Object)BlocksTFC.register((IForgeRegistry<Block>)r, "crop/" + crop.name().toLowerCase(), crop.createGrowingBlock()));
        }
        allCropBlocks = b.build();
        b = ImmutableList.builder();
        for (FruitTree[] crop : Crop.values()) {
            b.add((Object)BlocksTFC.register((IForgeRegistry<Block>)r, "dead_crop/" + crop.name().toLowerCase(), crop.createDeadBlock()));
        }
        allDeadCropBlocks = b.build();
        ImmutableList.Builder fSaplings = ImmutableList.builder();
        ImmutableList.Builder fTrunks = ImmutableList.builder();
        ImmutableList.Builder fBranches = ImmutableList.builder();
        ImmutableList.Builder fLeaves = ImmutableList.builder();
        for (FruitTree tree : FruitTree.values()) {
            fSaplings.add((Object)BlocksTFC.register((IForgeRegistry<Block>)r, "fruit_trees/sapling/" + tree.name().toLowerCase(), new BlockFruitTreeSapling(tree), CreativeTabsTFC.CT_WOOD));
            fTrunks.add((Object)BlocksTFC.register((IForgeRegistry<Block>)r, "fruit_trees/trunk/" + tree.name().toLowerCase(), new BlockFruitTreeTrunk(tree)));
            fBranches.add((Object)BlocksTFC.register((IForgeRegistry<Block>)r, "fruit_trees/branch/" + tree.name().toLowerCase(), new BlockFruitTreeBranch(tree)));
            fLeaves.add((Object)BlocksTFC.register((IForgeRegistry<Block>)r, "fruit_trees/leaves/" + tree.name().toLowerCase(), new BlockFruitTreeLeaves(tree), CreativeTabsTFC.CT_WOOD));
        }
        allFruitTreeSaplingBlocks = fSaplings.build();
        allFruitTreeTrunkBlocks = fTrunks.build();
        allFruitTreeBranchBlocks = fBranches.build();
        allFruitTreeLeavesBlocks = fLeaves.build();
        ImmutableList.Builder fBerry = ImmutableList.builder();
        for (BerryBush bush : BerryBush.values()) {
            fBerry.add((Object)BlocksTFC.register((IForgeRegistry<Block>)r, "berry_bush/" + bush.name().toLowerCase(), new BlockBerryBush(bush), CreativeTabsTFC.CT_FOOD));
        }
        allBerryBushBlocks = fBerry.build();
        allFruitTreeSaplingBlocks.forEach(x -> inventoryItemBlocks.add((Object)new ItemBlockTFC((Block)x)));
        allFruitTreeLeavesBlocks.forEach(x -> inventoryItemBlocks.add((Object)new ItemBlockTFC((Block)x)));
        allBerryBushBlocks.forEach(x -> inventoryItemBlocks.add((Object)new ItemBlockTFC((Block)x)));
        b = ImmutableList.builder();
        ImmutableList.Builder pots = ImmutableList.builder();
        for (Plant plant : TFCRegistries.PLANTS.getValuesCollection()) {
            if (plant.getPlantType() != Plant.PlantType.SHORT_GRASS && plant.getPlantType() != Plant.PlantType.TALL_GRASS) {
                b.add((Object)BlocksTFC.register((IForgeRegistry<Block>)r, "plants/" + plant.getRegistryName().func_110623_a(), plant.getPlantType().create(plant), CreativeTabsTFC.CT_FLORA));
            }
            if (!plant.canBePotted()) continue;
            pots.add((Object)BlocksTFC.register((IForgeRegistry<Block>)r, "flowerpot/" + plant.getRegistryName().func_110623_a(), new BlockFlowerPotTFC(plant)));
        }
        allPlantBlocks = b.build();
        allFlowerPots = pots.build();
        for (BlockPlantTFC blockPlant : allPlantBlocks) {
            if (blockPlant instanceof BlockFloatingWaterTFC) {
                inventoryItemBlocks.add((Object)new ItemBlockFloatingWaterTFC((BlockFloatingWaterTFC)blockPlant));
                continue;
            }
            if (blockPlant.getPlant().canBePotted()) {
                normalItemBlocks.add((Object)new ItemBlockPlant((Block)blockPlant, blockPlant.getPlant()));
                continue;
            }
            normalItemBlocks.add((Object)new ItemBlockTFC((Block)blockPlant));
        }
        b = ImmutableList.builder();
        for (Plant plant : TFCRegistries.PLANTS.getValuesCollection()) {
            if (plant.getPlantType() != Plant.PlantType.SHORT_GRASS && plant.getPlantType() != Plant.PlantType.TALL_GRASS) continue;
            b.add((Object)BlocksTFC.register((IForgeRegistry<Block>)r, "plants/" + plant.getRegistryName().func_110623_a(), plant.getPlantType().create(plant), CreativeTabsTFC.CT_FLORA));
        }
        allGrassBlocks = b.build();
        for (BlockPlantTFC blockPlant : allGrassBlocks) {
            normalItemBlocks.add((Object)new ItemBlockTFC((Block)blockPlant));
        }
        inventoryItemBlocks.add((Object)new ItemBlock((Block)BlocksTFC.register((IForgeRegistry<Block>)r, "firepit", new BlockFirePit())));
        inventoryItemBlocks.add((Object)new ItemBlock((Block)BlocksTFC.register((IForgeRegistry<Block>)r, "charcoal_forge", new BlockCharcoalForge())));
        inventoryItemBlocks.add((Object)new ItemBlock((Block)BlocksTFC.register((IForgeRegistry<Block>)r, "pit_kiln", new BlockPitKiln())));
        inventoryItemBlocks.add((Object)new ItemBlock((Block)BlocksTFC.register((IForgeRegistry<Block>)r, "placed_item", new BlockPlacedItem())));
        BlocksTFC.register((IForgeRegistry<Block>)r, "placed_item_flat", new BlockPlacedItemFlat());
        BlocksTFC.register((IForgeRegistry<Block>)r, "placed_hide", new BlockPlacedHide());
        BlocksTFC.register((IForgeRegistry<Block>)r, "charcoal_pile", new BlockCharcoalPile());
        BlocksTFC.register((IForgeRegistry<Block>)r, "ingot_pile", new BlockIngotPile());
        BlocksTFC.register((IForgeRegistry<Block>)r, "log_pile", new BlockLogPile());
        BlocksTFC.register((IForgeRegistry<Block>)r, "molten", new BlockMolten());
        BlocksTFC.register((IForgeRegistry<Block>)r, "bloom", new BlockBloom());
        BlocksTFC.register((IForgeRegistry<Block>)r, "thatch_bed", new BlockThatchBed());
        allNormalItemBlocks = normalItemBlocks.build();
        allInventoryItemBlocks = inventoryItemBlocks.build();
        BlocksTFC.register(TETickCounter.class, "tick_counter");
        BlocksTFC.register(TEPlacedItem.class, "placed_item");
        BlocksTFC.register(TEPlacedItemFlat.class, "placed_item_flat");
        BlocksTFC.register(TEPlacedHide.class, "placed_hide");
        BlocksTFC.register(TEPitKiln.class, "pit_kiln");
        BlocksTFC.register(TEChestTFC.class, "chest");
        BlocksTFC.register(TENestBox.class, "nest_box");
        BlocksTFC.register(TELogPile.class, "log_pile");
        BlocksTFC.register(TEIngotPile.class, "ingot_pile");
        BlocksTFC.register(TEFirePit.class, "fire_pit");
        BlocksTFC.register(TEToolRack.class, "tool_rack");
        BlocksTFC.register(TELoom.class, "loom");
        BlocksTFC.register(TELamp.class, "lamp");
        BlocksTFC.register(TEBellows.class, "bellows");
        BlocksTFC.register(TEBarrel.class, "barrel");
        BlocksTFC.register(TECharcoalForge.class, "charcoal_forge");
        BlocksTFC.register(TEAnvilTFC.class, "anvil");
        BlocksTFC.register(TECrucible.class, "crucible");
        BlocksTFC.register(TECropBase.class, "crop_base");
        BlocksTFC.register(TECropSpreading.class, "crop_spreading");
        BlocksTFC.register(TEBlastFurnace.class, "blast_furnace");
        BlocksTFC.register(TEBloomery.class, "bloomery");
        BlocksTFC.register(TEBloom.class, "bloom");
        BlocksTFC.register(TEMetalSheet.class, "metal_sheet");
        BlocksTFC.register(TEQuern.class, "quern");
        BlocksTFC.register(TELargeVessel.class, "large_vessel");
        BlocksTFC.register(TEPowderKeg.class, "powderkeg");
        BlocksTFC.register(TESluice.class, "sluice");
    }

    @SubscribeEvent(priority=EventPriority.LOWEST)
    public static void registerVanillaOverrides(RegistryEvent.Register<Block> event) {
        if (ConfigTFC.General.OVERRIDES.enableFrozenOverrides) {
            TerraFirmaCraft.getLog().info("The below warnings about unintended overrides are normal. The override is intended. ;)");
            event.getRegistry().registerAll((IForgeRegistryEntry[])new Block[]{((Block)new BlockIceTFC(FluidsTFC.FRESH_WATER.get()).setRegistryName("minecraft", "ice")).func_149663_c("ice"), ((Block)new BlockSnowTFC().setRegistryName("minecraft", "snow_layer")).func_149663_c("snow")});
        }
        if (ConfigTFC.General.OVERRIDES.enableTorchOverride) {
            event.getRegistry().register((IForgeRegistryEntry)((Block)new BlockTorchTFC().setRegistryName("minecraft", "torch")).func_149663_c("torch"));
        }
    }

    public static boolean isWater(IBlockState current) {
        return current.func_185904_a() == Material.field_151586_h;
    }

    public static boolean isFreshWater(IBlockState current) {
        return current == FluidsTFC.FRESH_WATER.get().getBlock().func_176223_P();
    }

    public static boolean isSaltWater(IBlockState current) {
        return current == FluidsTFC.SALT_WATER.get().getBlock().func_176223_P();
    }

    public static boolean isFreshWaterOrIce(IBlockState current) {
        return current.func_177230_c() == Blocks.field_150432_aD || BlocksTFC.isFreshWater(current);
    }

    public static boolean isRawStone(IBlockState current) {
        if (!(current.func_177230_c() instanceof BlockRockVariant)) {
            return false;
        }
        Rock.Type type = ((BlockRockVariant)current.func_177230_c()).getType();
        return type == Rock.Type.RAW;
    }

    public static boolean isClay(IBlockState current) {
        if (!(current.func_177230_c() instanceof BlockRockVariant)) {
            return false;
        }
        Rock.Type type = ((BlockRockVariant)current.func_177230_c()).getType();
        return type == Rock.Type.CLAY || type == Rock.Type.CLAY_GRASS;
    }

    public static boolean isDirt(IBlockState current) {
        if (!(current.func_177230_c() instanceof BlockRockVariant)) {
            return false;
        }
        Rock.Type type = ((BlockRockVariant)current.func_177230_c()).getType();
        return type == Rock.Type.DIRT;
    }

    public static boolean isSand(IBlockState current) {
        if (!(current.func_177230_c() instanceof BlockRockVariant)) {
            return false;
        }
        Rock.Type type = ((BlockRockVariant)current.func_177230_c()).getType();
        return type == Rock.Type.SAND;
    }

    public static boolean isSoil(IBlockState current) {
        if (current.func_177230_c() instanceof BlockPeat) {
            return true;
        }
        if (!(current.func_177230_c() instanceof BlockRockVariant)) {
            return false;
        }
        Rock.Type type = ((BlockRockVariant)current.func_177230_c()).getType();
        return type == Rock.Type.GRASS || type == Rock.Type.DRY_GRASS || type == Rock.Type.DIRT || type == Rock.Type.CLAY || type == Rock.Type.CLAY_GRASS;
    }

    public static boolean isGrowableSoil(IBlockState current) {
        if (current.func_177230_c() instanceof BlockPeat) {
            return false;
        }
        if (!(current.func_177230_c() instanceof BlockRockVariant)) {
            return false;
        }
        Rock.Type type = ((BlockRockVariant)current.func_177230_c()).getType();
        return type == Rock.Type.GRASS || type == Rock.Type.DRY_GRASS || type == Rock.Type.DIRT || type == Rock.Type.CLAY || type == Rock.Type.CLAY_GRASS;
    }

    public static boolean isSoilOrGravel(IBlockState current) {
        if (current.func_177230_c() instanceof BlockPeat) {
            return true;
        }
        if (!(current.func_177230_c() instanceof BlockRockVariant)) {
            return false;
        }
        Rock.Type type = ((BlockRockVariant)current.func_177230_c()).getType();
        return type == Rock.Type.GRASS || type == Rock.Type.DRY_GRASS || type == Rock.Type.DIRT || type == Rock.Type.GRAVEL;
    }

    public static boolean isGrass(IBlockState current) {
        if (current.func_177230_c() instanceof BlockPeatGrass) {
            return true;
        }
        if (!(current.func_177230_c() instanceof BlockRockVariant)) {
            return false;
        }
        Rock.Type type = ((BlockRockVariant)current.func_177230_c()).getType();
        return type.isGrass;
    }

    public static boolean isDryGrass(IBlockState current) {
        if (!(current.func_177230_c() instanceof BlockRockVariant)) {
            return false;
        }
        Rock.Type type = ((BlockRockVariant)current.func_177230_c()).getType();
        return type == Rock.Type.DRY_GRASS;
    }

    public static boolean isGround(IBlockState current) {
        if (!(current.func_177230_c() instanceof BlockRockVariant)) {
            return false;
        }
        Rock.Type type = ((BlockRockVariant)current.func_177230_c()).getType();
        return type == Rock.Type.GRASS || type == Rock.Type.DRY_GRASS || type == Rock.Type.DIRT || type == Rock.Type.GRAVEL || type == Rock.Type.RAW || type == Rock.Type.SAND;
    }

    private static <T extends Block> T register(IForgeRegistry<Block> r, String name, T block, CreativeTabs ct) {
        block.func_149647_a(ct);
        return BlocksTFC.register(r, name, block);
    }

    private static <T extends Block> T register(IForgeRegistry<Block> r, String name, T block) {
        block.setRegistryName("tfc", name);
        block.func_149663_c("tfc." + name.replace('/', '.'));
        r.register(block);
        return block;
    }

    private static <T extends TileEntity> void register(Class<T> te, String name) {
        TileEntity.func_190560_a((String)("tfc:" + name), te);
    }
}

